﻿  package{
	  import flash.display.*;
	  import flash.text.TextField;	  
	  import flash.text.TextFormat;
	  import flash.text.TextFormatAlign;
	  import flash.events.*;
	  import flash.geom.Rectangle;
	  import flash.geom.Point;
	  
	  public class Dialog extends MovieClip{
		  
		  public var flag_hasStageEvent = false;	//if stage event found or not
		  public var noDragFlag:Boolean = false;
		  
		  //inner elements:
		  //mc_buttonOK
		  //txt_message
		  //txt_caption
		  
		  //constructor
		  public function Dialog(){
 			  this.addEventListener(MouseEvent.MOUSE_DOWN,mouseDown_handler);
			  this.txt_caption.mouseEnabled = false;
			  this.txt_message.mouseEnabled = false;
			  
			  CommonFunctions.initSimpleButton(this.mc_buttonOK);
			  
			  this.mc_buttonOK.addEventListener(MouseEvent.CLICK,buttonOkClick_handler);			  
			  this.mc_buttonOK.addEventListener(MouseEvent.MOUSE_DOWN,buttonDownClick_handler);
		  }
		  
		  //------------------------------------------------------------------
		  // position the dialog to parent center
		  public function positionParentCenter(){			  	
			  	var website = this.parent;
				if(website == null) return(false);
				var centerPoint:Point = website.centerPoint;			
				
				this.x = centerPoint.x - Math.floor((this.width)/2);				
				this.y = centerPoint.y - Math.floor((this.height)/2)-50;
		  }
		  
		  //------------------------------------------------------------------
		  // mouse down handler. start drag the dialog.
		  private function mouseDown_handler(event:MouseEvent){
			  if(this.noDragFlag == true){
				  this.noDragFlag = false;
				  return(false);
			  }
			  
			  if(this.flag_hasStageEvent == false){		//add once stage mouseup event
				  stage.addEventListener(MouseEvent.MOUSE_UP,stageMouseUp_handler);
				  this.flag_hasStageEvent = true;
			  }			  
			  var website = this.parent;			  			  
			  if(website == null) this.startDrag(false);
			  else{		//bound the drag area of the dialog to the parent.
			  	var rect1:Rectangle = website.boundRect;
			  	var rect:Rectangle = new Rectangle(rect1.x,rect1.y,rect1.width-this.width,rect1.height-this.height);
				this.startDrag(false,rect);
			  }
		  }
		  
		  //------------------------------------------------------------------
		  //stage mouse up handler. stop dragging
		  private function stageMouseUp_handler(event:MouseEvent){
			  this.stopDrag();
		  }
		  
		  //------------------------------------------------------------------
		  //event on button mouse down. stop the dragging.
		  public function buttonDownClick_handler(event:MouseEvent){
			  this.noDragFlag = true;
		  }
		  
		  //------------------------------------------------------------------
		  //format the messages
		  public function formatDialog(type:String=""){
			  var formatCaption:TextFormat = new TextFormat();
			  var formatText:TextFormat = new TextFormat();
			  
			  formatCaption.align = "left";
			  formatCaption.bold = true;
			  
			  formatText.align="left";
			  formatText.bold = false;
			  
			  this.txt_caption.setTextFormat(formatCaption);
			  this.txt_message.setTextFormat(formatText);			  
		  }
		  
		  //------------------------------------------------------------------
		  //event on button click. hide the dialog.
		  public function buttonOkClick_handler(event:MouseEvent){
				this.visible = false;
		  }
		  
		  //------------------------------------------------------------------
		  //show the dialog with text
		  public function show(type:String,caption:String,text:String){
			  this.txt_caption.visible = true;
			  this.txt_message.visible = true;			  				  
			  
			  positionParentCenter();
			  
			  this.txt_caption.text = caption;
			  this.txt_message.text = text;
			  
			  switch(type){
				  case "textonly":
				  	this.txt_caption.visible = false;
				  break;
			  }
			  
			  formatDialog(type);
			  this.visible = true;
		  }
		  
		  //------------------------------------------------------------------
		  //hide the dialog
		  public function hide(){
			  this.visible = false;
		  }
	  }   
  }